//  
//    This source code is a part of the following blog post:
//    
//        https://dennisbabkin.com/blog/?i=AAA08000
//    
//    Licensed under the Apache License, Version 2.0 (the "License");
//    you may not use this file except in compliance with the License.
//    You may obtain a copy of the License at
//    
//        https://www.apache.org/licenses/LICENSE-2.0
//    
//    Unless required by applicable law or agreed to in writing, software
//    distributed under the License is distributed on an "AS IS" BASIS,
//    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//    See the License for the specific language governing permissions and
//    limitations under the License.
//  
//

#include "pch.h"

#include "native_stuff.h"				//Native declarations


BOOL APIENTRY DllMain( HMODULE hModule,
                       DWORD  ul_reason_for_call,
                       LPVOID lpReserved
                     )
{
    switch (ul_reason_for_call)
    {
    case DLL_PROCESS_ATTACH:
    case DLL_THREAD_ATTACH:
    case DLL_THREAD_DETACH:
    case DLL_PROCESS_DETACH:
        break;
    }
    return TRUE;
}



void ExecUX(HANDLE hToken, PCWSTR CommandLine, BOOL bWait = FALSE)
{
	WCHAR ApplicationName[MAX_PATH];
	if (ExpandEnvironmentStringsW(L"%systemroot%\\system32\\MusNotificationUx.exe", ApplicationName, _countof(ApplicationName)))
	{
		PROCESS_INFORMATION pi;
		STARTUPINFO si = { sizeof(si) };
		if (CreateProcessAsUserW(hToken, ApplicationName, const_cast<PWSTR>(CommandLine), 0, 0, 0, 0, 0, 0, &si, &pi))
		{
			NtClose(pi.hThread);
			if (bWait) WaitForSingleObject(pi.hProcess, INFINITE);
			NtClose(pi.hProcess);
		}
	}
}

void Shell_RequestShutdown(int)
{
	bool IsRebootUXLaunched = false;

	static const WCHAR kRk[] = L"\\REGISTRY\\MACHINE\\SOFTWARE\\Microsoft\\WindowsUpdate\\UX\\StateVariables";
	static const UNICODE_STRING sRk = { sizeof(kRk) - sizeof((kRk)[0]), sizeof(kRk), const_cast<PWSTR>(kRk) };
	static OBJECT_ATTRIBUTES oa = { sizeof(oa), 0, const_cast<PUNICODE_STRING>(&sRk), OBJ_CASE_INSENSITIVE };

	HANDLE hKey;
	if (0 <= ZwOpenKey(&hKey, KEY_QUERY_VALUE, &oa))
	{
		static const WCHAR kRbt[] = L"RebootUXLaunched";
		static const UNICODE_STRING RebootUXLaunched = { sizeof(kRbt) - sizeof((kRbt)[0]), sizeof(kRbt), const_cast<PWSTR>(kRbt) };

		KEY_VALUE_PARTIAL_INFORMATION kvpi;
		IsRebootUXLaunched = 0 <= ZwQueryValueKey(hKey, const_cast<PUNICODE_STRING>(&RebootUXLaunched),
			KeyValuePartialInformation, &kvpi, sizeof(kvpi), &kvpi.TitleIndex) &&
			kvpi.DataLength == sizeof(ULONG) && kvpi.Type == REG_DWORD && *(ULONG*)kvpi.Data;
		NtClose(hKey);
	}

	if (IsRebootUXLaunched)
	{
		ULONG dwShutdownFlags = SHUTDOWN_ARSO | SHUTDOWN_RESTARTAPPS | SHUTDOWN_RESTART |
			SHUTDOWN_INSTALL_UPDATES | SHUTDOWN_FORCE_SELF | SHUTDOWN_FORCE_OTHERS;

		if (GetShellWindow())
		{
			ExecUX(0, L"* ClearActiveNotifications", TRUE);

			dwShutdownFlags = wcsstr(GetCommandLineW(), L"RebootWithUXForceOthers")
				? SHUTDOWN_ARSO | SHUTDOWN_RESTARTAPPS | SHUTDOWN_RESTART | SHUTDOWN_INSTALL_UPDATES | SHUTDOWN_FORCE_OTHERS
				: SHUTDOWN_ARSO | SHUTDOWN_RESTARTAPPS | SHUTDOWN_RESTART | SHUTDOWN_INSTALL_UPDATES;
		}

		InitiateShutdownW(0, 0, 0, dwShutdownFlags,
			SHTDN_REASON_FLAG_PLANNED |
			SHTDN_REASON_MAJOR_OPERATINGSYSTEM |
			SHTDN_REASON_MINOR_SERVICEPACK);

		return;
	}

	static const TOKEN_PRIVILEGES tp_No_Shutdown = { 1, { { { SE_SHUTDOWN_PRIVILEGE } } } };

	HANDLE hToken, hNewToken = 0;

	if (0 <= NtOpenProcessToken(NtCurrentProcess(), TOKEN_DUPLICATE, &hToken))
	{
		BOOL b = DuplicateTokenEx(hToken, TOKEN_ADJUST_PRIVILEGES | TOKEN_IMPERSONATE,
			0, ::SecurityImpersonation, ::TokenImpersonation, &hNewToken);

		NtClose(hToken);

		if (b)
		{
			if (0 <= NtAdjustPrivilegesToken(hNewToken, FALSE, const_cast<PTOKEN_PRIVILEGES>(&tp_No_Shutdown), 0, 0, 0))
			{
				NtSetInformationThread(NtCurrentThread(), ThreadImpersonationToken, &hNewToken, sizeof(hNewToken));
			}

			NtClose(hNewToken);
		}
	}

	static const WCHAR Toast_FairWarning[] = L"* Toast_FairWarningDesktop";

	if (GetShellWindow())
	{
		ExecUX(0, Toast_FairWarning);
		ExitProcess(0);
	}

	ULONG dwSessionId = WTSGetActiveConsoleSessionId();

	if (dwSessionId != MAXULONGLONG && WTSQueryUserToken(dwSessionId, &hToken))
	{
		ExecUX(hToken, Toast_FairWarning);
		NtClose(hToken);
	}
}

